﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IndianHealthService.BMXNet
{
    /// <summary>
    /// To test the BMXNetLib class, we can use one instance of BMXNetLib
    /// to be the authenicated transport and use the receiver to be the
    /// encapsulated BMX interaction.
    /// </summary>
    public class BMXNetOverAnotherLib:BMXNetLib
    {

        public static BMXNetLib OpenOn(BMXNetLib aNetLib)
        {
            BMXNetOverAnotherLib answer = new BMXNetOverAnotherLib();
            answer.NetLib = aNetLib;
            return answer;
        }

        private BMXNetLib _netLib = null;

        public BMXNetLib NetLib
        {
            get { return _netLib; }
            set { _netLib = value; }
        }

        protected override string SendReceiveString(string sendString, string multi)
        {
            return this.DecodeReceiveString(this.NetLib.TransmitRPC("CIABMX", this.EncodeSendString(sendString,multi)));
        }

        public override string GetLoginFacility()
        {
            return this.NetLib.GetLoginFacility();
        }

        public override bool IsConnected
        {
            get
            {
                return this.NetLib.IsConnected;
            }
        }
    }
}
